"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeaderboardConstants = void 0;
var LeaderboardConstants;
(function (LeaderboardConstants) {
    let FullLeaderboard;
    (function (FullLeaderboard) {
        FullLeaderboard.PRELOAD_ENTRY_COUNT = 20;
        FullLeaderboard.ENTRY_SIZE_Y = 0.13;
        FullLeaderboard.ENTRIES_LIMIT_TOP_POSITION_Y = 0.79;
        FullLeaderboard.ENTRIES_NEEDED_FOR_SCROLL = 8;
        FullLeaderboard.PARENT_HEADER_ANCHORS = Rect.create(-1, 1, -1.20, 0.8);
        FullLeaderboard.PARENT_NO_HEADER_ANCHORS = Rect.create(-1, 1, -1, 1);
        FullLeaderboard.HEADER_MASK_TOP_ANCHORS = Rect.create(-1, 1, FullLeaderboard.ENTRIES_LIMIT_TOP_POSITION_Y, 1.1);
        FullLeaderboard.NO_HEADER_MASK_TOP_ANCHORS = Rect.create(-1, 1, FullLeaderboard.ENTRIES_LIMIT_TOP_POSITION_Y, 0.98);
        FullLeaderboard.MIN_Y_COORD_TO_SHOW_ENTRY = -0.4;
        FullLeaderboard.MAX_Y_COORD_TO_SHOW_ENTRY = 0.9;
        FullLeaderboard.ENTRIES_BOTTOM_LIMIT_POSITION_HEADER = -0.1;
        FullLeaderboard.ENTRIES_BOTTOM_LIMIT_POSITION_NO_HEADER = 0;
        FullLeaderboard.ENTRIES_TOP_LIMIT_POSITION = FullLeaderboard.ENTRIES_LIMIT_TOP_POSITION_Y - FullLeaderboard.ENTRY_SIZE_Y / 2;
        FullLeaderboard.ANIMATION_DURATION_MS = 400;
        FullLeaderboard.CUSTOM_TEXTURE_START_RECT = Rect.create(-1, 1, -0.481, 1.00);
        FullLeaderboard.CUSTOM_TEXTURE_END_RECT = Rect.create(-1, 1, -1, 1);
        FullLeaderboard.CUSTOM_TEXTURE_PARENT_START_RECT = Rect.create(-1, 1, 0.3, 3);
        FullLeaderboard.CUSTOM_TEXTURE_PARENT_END_RECT = Rect.create(-0.3, 0.3, 0.15, 0.8);
        FullLeaderboard.TOP_BORDER_BOTTOM_START_VALUE = 1;
        FullLeaderboard.TOP_BORDER_BOTTOM_END_VALUE = 2;
        FullLeaderboard.ROUND_CORNER_SCALE_X_START_VALUE = 2;
        FullLeaderboard.ROUND_CORNER_SCALE_X_END_VALUE = 1;
        FullLeaderboard.TOUCH_COUNT_TO_CLOSE_VIEW = 2;
        FullLeaderboard.INITIAL_PARENT_POSITION = new vec2(0, -2);
        FullLeaderboard.DAILY_RESET_STRING = "Resets daily";
        FullLeaderboard.WEEKLY_RESET_STRING = "Resets weekly";
        FullLeaderboard.MONTHLY_RESET_STRING = "Resets monthly";
        FullLeaderboard.YEARLY_RESET_STRING = "Resets yearly";
    })(FullLeaderboard = LeaderboardConstants.FullLeaderboard || (LeaderboardConstants.FullLeaderboard = {}));
    let SingleBadge;
    (function (SingleBadge) {
        SingleBadge.POSITION = new vec2(-0.70, -0.90);
        SingleBadge.POSITION_OUT_OF_SCREEN = new vec2(-3, -0.90);
        SingleBadge.ANIMATION_DURATION_MS = 500;
    })(SingleBadge = LeaderboardConstants.SingleBadge || (LeaderboardConstants.SingleBadge = {}));
    let InertialAnimation;
    (function (InertialAnimation) {
        InertialAnimation.MAX_SPEED = 4;
        InertialAnimation.FRICTION = 1.5;
        InertialAnimation.SNAP_DURATION = 0.3;
        InertialAnimation.SPRINGNESS = 1000;
    })(InertialAnimation = LeaderboardConstants.InertialAnimation || (LeaderboardConstants.InertialAnimation = {}));
    let Component;
    (function (Component) {
        Component.USER_LIMIT_FRIENDS = 50;
        Component.USER_LIMIT_GLOBAL = 10;
    })(Component = LeaderboardConstants.Component || (LeaderboardConstants.Component = {}));
})(LeaderboardConstants || (exports.LeaderboardConstants = LeaderboardConstants = {}));
//# sourceMappingURL=LeaderboardConstants.js.map